''**************************
''*  JB 2600style Driver   *
''*  (C) 2007 Jim Bagley.  *
''**************************

CON
  PARAM_COUNT   = 9

VAR
  long  cog

VAR
    long    rend_cog_number        'each cog gets a different number, starting with zero     write-only
    long    rend_cog_count         'total number of cogs                                     write-only
    long    rend_scanline_req      'a pointer to the request to put a line in the scan buffer   write-only
    long    rend_scanline_buffer   'hub memory where renderer puts scanline when requested write-only
    long    rend_scanxsize
    long    rend_scanysize
    long    rend_mode
    long    rend_tvstatus_ptr
    long    rend_lines_ptr

PUB Start(aCogs,TvParamsPtr) | i

    rend_cog_count := aCogs
    rend_scanline_req := long[TvParamsPtr+(14*4)]
    rend_scanline_buffer := long[TvParamsPtr+(12*4)]
    rend_scanxsize := long[TvParamsPtr+(4*4)]*4
    rend_scanysize := long[TvParamsPtr+(5*4)]*16
    rend_mode := long[TvParamsPtr+(3*4)]
    rend_tvstatus_ptr := TvParamsPtr
    rend_lines_ptr := long[TvParamsPtr+(15*4)]

    repeat i from 0 to aCogs-1
        rend_cog_number := i
        rend_scanline_buffer:=long[TvParamsPtr+(12*4)]+(i*(160+16))
        cognew(@entry,@rend_cog_number)
        'Wait to allow this cog to get the cog number param from the block before changing it.
        repeat 1000

DAT

'******************************
'* Assembly language renderer *
'******************************
                        org
'
' Entry
'
entry
                        rdlong  cog_rend_cog_number,PAR

                        mov     r0,PAR
                        movd    :load_dest1,#renderer_params+1
                        mov     count,#param_count-1
:load1                  add     r0,#4
:load_dest1             rdlong  0-0,r0
                        add     :load_dest1,inc_dest
                        djnz    count,#:load1

                        mov     current_line,cog_rend_cog_number  'start rendering from the top
                        test    cog_rend_mode,#%0010    wz      'if interlaced
               if_nz    add     current_line,cog_rend_cog_number
do_line

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

                        mov     r1,cog_rend_tvstatus_ptr
                        add     r1,#17*4
                        rdlong  cog_dsplst_ptr,r1
                        add     r1,#4
                        rdlong  cog_sprset_ptr,r1
                        add     r1,#4
                        mov     r0,current_line
                        rdlong  cog_scrmap_ptr,r1
                        shl     r0,#3
                        add     r1,#4
                        rdlong  cog_palette_ptr,r1

                        add     cog_dsplst_ptr,r0
                        mov     destptr,cog_rend_scanline_buffer

                        rdlong  indata,cog_dsplst_ptr
                        add     cog_dsplst_ptr,#4
                        add     destptr,#8
                        
                        rdlong  indata2,cog_dsplst_ptr

                        mov     colour0,indata2
                        shr     colour0,#8
                        and     colour0,#255 wz
          if_z          jmp     #:dochars
                        mov     r0,colour0
                        shl     r0,#8
                        or      colour0,r0
                        mov     r0,colour0
                        shl     r0,#16
                        or      colour0,r0
                        
                        mov     colour1,indata2
                        shr     colour1,#16
                        and     colour1,#255
                        mov     r0,colour1
                        shl     r0,#8
                        or      colour1,r0
                        mov     r0,colour1
                        shl     r0,#16
                        or      colour1,r0

                        mov     r0,indata
                        mov     r3,#4
                        call    #DoXLoop
                        mov     r0,indata2
                        mov     r3,#1
                        call    #DoXLoop
                        
                        jmp     #:doneline
                        
:dochars                mov     r0,current_line
                        shr     r0,#3
                        mov     r2,r0
                        shl     r2,#3
                        shl     r0,#5
                        add     r0,r2
                        add     cog_scrmap_ptr,r0
                        mov     r0,current_line
                        and     r0,#7
                        shl     r0,#2
                        add     r0,cog_sprset_ptr
                        sub     destptr,#1
                        
                        mov     r1,#20

:xloop2                 rdword  r5,cog_scrmap_ptr
                        add     cog_scrmap_ptr,#2
                        mov     r6,r5
                        shr     r6,#8-4
                        and     r5,#255
                        shl     r5,#5
                        add     r5,r0
                        rdlong  r2,r5
                        and     r6,xff0
                        add     r6,cog_palette_ptr


                        mov     r3,#8           'next byte counter
:x2loop2
                        mov     r4,r2
                        and     r4,#15
                        add     r4,r6
                        rdbyte  r4,r4
                        ror     r2,#4
                        add     destptr,#1
                        wrbyte  r4,destptr

                        djnz    r3,#:x2loop2
                        
                        djnz    r1,#:xloop2

                        rdlong  r0,cog_rend_scanline_req
                        cmp     r0,current_line wc,wz
              if_a      jmp     #gonext
                        jmp     #wait_for_the_request
                        jmp     #gonext
:doneline                        

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
' now do sprites

                        mov     r1,cog_rend_tvstatus_ptr
                        add     r1,#22*4
                        rdlong  r2,r1
                        add     r1,#4

:spriteslp              rdlong  tmpx,r1
                        mov     tmpy,tmpx
                        mov     tmpp,tmpx

                        sar     tmpy,#8
                        and     tmpy,#255
                        sub     tmpy,current_line wc
              if_c      jmp     #:skpspr
                        cmp     tmpy,#8 wc,wz
              if_ae     jmp     #:skpspr
                        add     tmpx,#8

                        and     tmpx,#255
                        cmp     tmpx,#168 wc,wz

              if_ae     jmp     #:skpspr
                        xor     tmpy,#7
                        and     tmpx,#255
                        sub     tmpx,#8

                        mov     tmpc,tmpp
                        shr     tmpp,#16
                        and     tmpp,#$ff
                        shl     tmpp,#4
                        add     tmpp,cog_palette_ptr
                        shr     tmpc,#24
                        and     tmpc,#255

                        mov     destptr,cog_rend_scanline_buffer
                        add     destptr,#8-1
                        add     destptr,tmpx

                        shl     tmpy,#2
                        shl     tmpc,#5
                        add     tmpc,tmpy
                        add     tmpc,cog_sprset_ptr

                        rdlong  r0,tmpc
                        mov     r3,#8           'next byte counter
:sx2loop
                        mov     r4,r0
                        and     r4,#15 wz
                        add     r4,tmpp
                        rdbyte  r4,r4
                        add     destptr,#1
                        ror     r0,#4
              if_nz     wrbyte  r4,destptr

                        djnz    r3,#:sx2loop

:skpspr                 add     r1,#4

                        rdlong  r0,cog_rend_scanline_req
                        cmp     r0,current_line wc,wz
              if_a      jmp     #gonext

                        djnz    r2,#:spriteslp              

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

wait_for_the_request    rdlong  r0,cog_rend_scanline_req
                        cmp     r0,current_line wz
              if_nz     jmp     #wait_for_the_request
wait_for_the_request2   rdlong  r0,cog_rend_scanline_req
                        cmp     r0,current_line wz
              if_z      jmp     #wait_for_the_request2

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

gonext                  add     current_line,cog_rend_cog_count 'we only do every Nth line
                        test    cog_rend_mode,#%0010    wz      'if interlaced
              if_nz     add     current_line,cog_rend_cog_count
              
                        cmp     current_line,cog_rend_scanysize wc,wz
              if_b      jmp     #do_line

                        mov     r0,cog_rend_tvstatus_ptr
                        add     r0,#16*4
:wait_lp                rdlong  r1,r0
                        cmp     r1,#1 wz
              if_nz     jmp     #:wait_lp

                        test    cog_rend_mode,#%0010    wz      'if interlaced
              if_nz     jmp     #start_interlaced
                        mov     current_line,cog_rend_cog_number
                        jmp     #do_line
start_interlaced
                        mov     r0,cog_rend_tvstatus_ptr
                        add     r0,#1
                        rdbyte  current_line,r0
                        and     current_line,#1
                        add     current_line,cog_rend_cog_number
                        add     current_line,cog_rend_cog_number
                        jmp     #do_line

DoXLoop                 mov     r2,#8
:xlp                    test    r0,#128 wz
                        mov     data,colour0
              if_nz     mov     data,colour1
                        wrlong  data,destptr
                        rol     r0,#1
                        add     destptr,#4
                        djnz    r2,#:xlp
                        ror     r0,#16
                        djnz    r3,#DoXLoop
DoXLoop_ret             ret                        
                        
              
'-------------------------------------------------------------------

' Initialized data
black                   long    $02_02_02_02
end_of_location_array   long    $FFFF_FFFF
char_set_start          long    $8000
ffffff00                long    $FFFFFF00
fff                     long    $FFF
inc_dest                long    1 << 9 << 0

xffff   long  $ffff
xff0    long  $ff0

indata  byte  %10101010,%10101010,%10101010,%10101010
indata2 byte  %10101010,$02,$2b,$02
   
colour0 long  $02020202
colour1 long  $2b2b2b2b
colour2 long  $2b2b2b2b

' End of scanline buffer
scanline_req            long    0

DAT 'Uninitiaised data - always keep it at the end of file to avoid nasty gotcha with RES.

renderer_params  
cog_rend_cog_number             res 1 'each cog gets a different number, starting with zero     write-only
cog_rend_cog_count              res 1 'total number of cogs                                     write-only
cog_rend_scanline_req           res 1 'a pointer to the request to put a line in the scan buffer   write-only
cog_rend_scanline_buffer        res 1 'hub memory where renderer puts scanline when requested write-only
cog_rend_scanxsize              res 1
cog_rend_scanysize              res 1
cog_rend_mode                   res 1
cog_rend_tvstatus_ptr           res 1
cog_rend_lines_ptr              res 1
    
cog_dsplst_ptr          res     1        
cog_sprset_ptr          res     1
cog_palette_ptr         res     1
cog_scrmap_ptr          res     1
        
current_line            res     1
r0                      res     1
r1                      res     1
r2                      res     1
r3                      res     1
r4                      res     1
r5                      res     1
r6                      res     1
count                   res     1
_mode                   res     1

destptr                 res     1
tmpx                    res     1
tmpy                    res     1
tmpp                    res     1
tmpc                    res     1

data                    res     1

                        fit
                        